<?php

require("../../../../config.php");
require("../../../../include/lib.php");
require("../../../../api/classes/db_class.php");
require("../../../../api/classes/comman_class.php");
require("../../../../api/classes/file_upload_s3.php");

$helpers = new helper_class();
$mysqlClass = new Mysql_class();
$post = $helpers->clearSlashes($_POST);

/**
 * QRcdr - php QR Code generator
 * ajax/process.php
 *
 * PHP version 5.4+
 *
 * @category  PHP
 * @package   QRcdr
 * @author    Nicola Franchini <info@veno.it>
 * @copyright 2015-2020 Nicola Franchini
 * @license   item sold on codecanyon https://codecanyon.net/item/qrcdr-responsive-qr-code-generator/9226839
 * @link      http://veno.es/qrcdr/
 */

// if (
//     !isset($_SERVER['HTTP_X_REQUESTED_WITH'])
//     || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest')
// ) {
//     exit;
// }
date_default_timezone_set('UTC');

require dirname(dirname(__FILE__)) . "/lib/functions.php";

if (qrcdr()->getConfig('debug_mode')) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(E_ALL ^ E_NOTICE);
}
$output_data = false;

$outdir = qrcdr()->getConfig('qrcodes_dir');
$PNG_TEMP_DIR = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . $outdir . DIRECTORY_SEPARATOR;
$PNG_WEB_DIR = $outdir . '/';

require dirname(dirname(__FILE__)) . "/lib/phpqrcode.php";
require dirname(dirname(__FILE__)) . "/lib/class-qrcdr.php";
require dirname(dirname(__FILE__)) . "/lib/frames.php";

qrcdr()->init();
$lang = qrcdr()->getLang();
if (file_exists(dirname(dirname(__FILE__)) . "/translations/" . $lang . ".php")) {
    include dirname(dirname(__FILE__)) . "/translations/" . $lang . ".php";
} else {
    include dirname(dirname(__FILE__)) . "/translations/en.php";
}

$output_data = false;
$getsection = filter_input(INPUT_POST, "section", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$setbackcolor = filter_input(INPUT_POST, "backcolor", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$setbackcolor = $setbackcolor ? $setbackcolor : qrcdr()->getConfig('qr_bgcolor');

$setfrontcolor = filter_input(INPUT_POST, "frontcolor", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$setfrontcolor = $setfrontcolor ? $setfrontcolor : qrcdr()->getConfig('qr_color');

$optionlogo = filter_input(INPUT_POST, "optionlogo", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$no_logo_bg = isset($_POST['no_logo_bg']);
$pattern = filter_input(INPUT_POST, "pattern", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$radial = isset($_POST['radial']);

$markerOut = filter_input(INPUT_POST, "marker_out", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$markerIn = filter_input(INPUT_POST, "marker_in", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$markerOutColor = filter_input(INPUT_POST, "marker_out_color", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$markerInColor = filter_input(INPUT_POST, "marker_in_color", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$gradient = isset($_POST['gradient']);
$gradient_color = filter_input(INPUT_POST, "gradient_color", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$markers_color = isset($_POST['markers_color']);
$negative_qr = isset($_POST['negative_qr']);
$nopdf = ($gradient || $negative_qr);

$different_markers_color = isset($_POST['different_markers_color']);

if ($different_markers_color) {
    $marker_top_right_outline = filter_input(INPUT_POST, "marker_top_right_outline", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $marker_top_right_center = filter_input(INPUT_POST, "marker_top_right_center", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $marker_bottom_left_outline = filter_input(INPUT_POST, "marker_bottom_left_outline", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $marker_bottom_left_center = filter_input(INPUT_POST, "marker_bottom_left_center", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
} else {
    $marker_top_right_outline = $marker_bottom_left_outline = $markerOutColor;
    $marker_top_right_center = $marker_bottom_left_center = $markerInColor;
}

$outerframe = filter_input(INPUT_POST, "outer_frame", FILTER_SANITIZE_FULL_SPECIAL_CHARS);

$custom_frame_color = isset($_POST['custom_frame_color']);
$framecolor = filter_input(INPUT_POST, "framecolor", FILTER_SANITIZE_FULL_SPECIAL_CHARS);

$prelabel = filter_input(INPUT_POST, "framelabel", FILTER_SANITIZE_FULL_SPECIAL_CHARS, FILTER_FLAG_NO_ENCODE_QUOTES);

$framelabel = iconv(mb_detect_encoding($prelabel ?? ''), 'UTF-8', $prelabel ?? '');

$words = explode(' ', $framelabel);

$framelabel = buildFramelabel($words);

function buildFramelabel($words)
{
    $framelabel = '';
    $rearrange = array();
    $start_ltr = false;
    $start_rtl = false;
    $rtl_counter = 0;
    $ltr_counter = 0;
    $thecounter = 0;

    foreach ($words as $key => $word) {
        $new_word = qrcdr()->reverseString($word);
        if (isRtl($word)) {
            // reverse word
            $new_word = qrcdr()->reverseString($word);
            if (!$start_rtl) {
                $rtl_counter++;
                $thecounter++;
                $rearrange[$thecounter . '_rtl'] = array();
            }
            $start_ltr = false;
            $start_rtl = true;
            $rearrange[$thecounter . '_rtl'][] = $new_word;
        } else {
            $new_word = $word;
            if (!$start_ltr) {
                $ltr_counter++;
                $thecounter++;
                $rearrange[$thecounter . '_ltr'] = array();
            }
            $start_ltr = true;
            $start_rtl = false;
            $rearrange[$thecounter . '_ltr'][] = $new_word;
        }
    }

    $rearrangeverse = $rearrange;
    if ($ltr_counter > 0 && $rtl_counter > $ltr_counter) {
        $rearrangeverse = array_reverse($rearrange);
    }

    foreach ($rearrangeverse as $key => $value) {
        $direction = substr($key, -3);
        if ($direction == 'rtl') {
            $framelabel .= implode(' ', array_reverse($value)) . ' ';
        } else {
            $framelabel .= implode(' ', $value) . ' ';
        }
    }
    $framelabel = trim($framelabel);
    return $framelabel;
}

function isRtl($value)
{
    $rtlChar = '/[\x{0590}-\x{083F}]|[\x{08A0}-\x{08FF}]|[\x{FB1D}-\x{FDFF}]|[\x{FE70}-\x{FEFF}]/u';
    return preg_match($rtlChar, $value) != 0;
}

$label_font = filter_input(INPUT_POST, "label_font", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$logo_size = filter_input(INPUT_POST, "logo_size", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$label_text_size = filter_input(INPUT_POST, "label-text-size", FILTER_SANITIZE_FULL_SPECIAL_CHARS);

$optionlogo = $optionlogo ? $optionlogo : 'none';
$outerframe = $outerframe ? $outerframe : 'none';

$labeltext_color = '#FFFFFF';
$basecolor = $custom_frame_color ? $framecolor : $setfrontcolor;
$rgb = qrcdr()->HTMLToRGB($basecolor);
$hsl = qrcdr()->RGBToHSL($rgb);
if ($hsl->lightness > 185) {
    $labeltext_color = '#000000';
}

$bg_image = 'none';
$transparent_code = isset($_POST['transparent_code']);
if ($transparent_code) {
    $bg_image = filter_input(INPUT_POST, "bg_image", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $bg_image = $bg_image ? $bg_image : 'none';
}

$optionstyle = array(
    'optionlogo' => $optionlogo,
    'pattern' => $pattern,
    'marker_out' => $markerOut,
    'marker_in' => $markerIn,
    'marker_out_color' => $markerOutColor,
    'marker_in_color' => $markerInColor,
    'marker_top_right_outline' => $marker_top_right_outline,
    'marker_top_right_center' => $marker_top_right_center,
    'marker_bottom_left_outline' => $marker_bottom_left_outline,
    'marker_bottom_left_center' => $marker_bottom_left_center,
    'gradient' => $gradient,
    'gradient_color' => $gradient_color,
    'markers_color' => $markers_color,
    'radial' => $radial,
    'no_logo_bg' => $no_logo_bg,
    'frame' => $outerframe,
    'custom_frame_color' => $custom_frame_color,
    'framecolor' => $framecolor,
    'framelabel' => $framelabel,
    'label_font' => $label_font,
    'labeltext_color' => $labeltext_color,
    'logo_size' => $logo_size,
    'label_text_size' => $label_text_size,
    'transparent_code' => $transparent_code,
    'bg_image' => $bg_image,
    'negative' => $negative_qr,
);

$stringbackcolor = $setbackcolor ? $setbackcolor : '#FFFFFF';
$stringfrontcolor = $setfrontcolor ? $setfrontcolor : '#000000';
$backcolor = qrcdr()->hexdecColor($stringbackcolor, '#FFFFFF');
$frontcolor = qrcdr()->hexdecColor($stringfrontcolor, '#000000');

$level = filter_input(INPUT_POST, "level", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$level = $level ? $level : qrcdr()->getConfig('precision');

if (in_array($level, array('L', 'M', 'Q', 'H'))) {
    $errorCorrectionLevel = $level;
    if ($optionlogo !== 'none' && $errorCorrectionLevel == 'L') {
        $errorCorrectionLevel = 'M';
    }
}
$size = filter_input(INPUT_POST, "size", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
$size = $size ? $size : 8;
$matrixPointSize = min(max((int)$size, 4), 32);

$link = $_POST['URL'];
$output_data = $link;
if ($output_data) {

    $backcolor = isset($_POST['transparent']) ? 'transparent' : $backcolor;

    // $optionlogo = $optionlogo && $optionlogo !== 'none' ? $optionlogo : false;
    $filename = $PNG_TEMP_DIR . md5($output_data . '|' . $errorCorrectionLevel . '|' . $matrixPointSize . time());
    $filenamesvg = $filename . '.svg';
    $basename = basename($filenamesvg, '.svg');

    $codemargin = $outerframe !== 'none' ? $frames[$outerframe]['frame_border'] * 2 + 1 : 2;
    $content = QRcdr::svg($output_data, $filenamesvg, $errorCorrectionLevel, $matrixPointSize, $codemargin, false, $backcolor, $frontcolor, $optionstyle);

    $result = array(
        'basename' => $basename,
        'content' => $content,
        'nopdf' => $nopdf,
    );
    $result = json_encode($result);
} else {
    $result = json_encode(
        array(
            'errore' => true,
            'placeholder' => qrcdr()->relativePath() . qrcdr()->getConfig('placeholder'),
        )
    );
}
echo $result;
