<?php
require("../../../../config.php");
require("../../../../include/lib.php");
require("../../../../api/classes/db_class.php");
require("../../../../api/classes/comman_class.php");
require("../../../../api/classes/file_upload_s3.php");
$helpers = new helper_class();
$mysqlClass = new Mysql_class();
/**
 * QRcdr - php QR Code generator
 * ajax/create.php
 *
 * PHP version 5.4+
 *
 * @category  PHP
 * @package   QRcdr
 * @author    Nicola Franchini <info@veno.it>
 * @copyright 2015-2020 Nicola Franchini
 * @license   item sold on codecanyon https://codecanyon.net/item/qrcdr-responsive-qr-code-generator/9226839
 * @link      http://veno.es/qrcdr/
 */
// if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) 
//     || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest')
// ) {
//     exit;
// }

$ref_code = isset($_REQUEST['ref']) ? $_REQUEST['ref'] : '';
$url = isset($_REQUEST['URL']) ? $_REQUEST['URL'] : '';
$data = isset($_POST['create']) ? $_POST['create'] : false;

if ($data) {
    require dirname(dirname(__FILE__)).'/lib/functions.php';
    $qrcodes_dir = qrcdr()->getConfig('qrcodes_dir');
    $decoded = json_decode($data);
    $svgheader = '<?xml version="1.0" encoding="utf-8"?><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">';
    $precontent = $svgheader.$decoded->content;
    
    if (class_exists('DOMDocument') && class_exists('XSLTProcessor')) {
        $xsl = new DOMDocument;
        $xsl->load('sanitize.xsl');
        $proc = new XSLTProcessor;
        $proc->importStyleSheet($xsl);
        $xml = simplexml_load_string($precontent);
        $content = $proc->transformToXML($xml);
    } else {
        $content = $precontent;
    }

    $basename = filter_var($decoded->basename, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

    if ($content && $basename) {
        $filedir = $qrcodes_dir;
        $filename_path = '../'.$filedir.'/'.$basename.'.svg';
        
        try {
            $handle = fopen($filename_path, "w");
            fwrite($handle, $content);
            fclose($handle);
            $inc_url = base64_decode(filter_var($url, FILTER_SANITIZE_URL));
            $qrUrl = $mysqlClass->mysqlQuery("SELECT ref_code,qr_url FROM qr_codes where ref_url = '{$inc_url}' AND ref_code = '{$ref_code}'");

            $resUrl = $qrUrl->fetch(PDO::FETCH_ASSOC);

            if ($resUrl['ref_code'] != $ref_code) {
                $qrupload = uploadToS3($filename_path, 'qrcodes/' . $basename.'.svg', 'svg');
                if ($qrupload == '200') {
                    $values = array(
                        'ref_code' => $ref_code,
                        'ref_url' => $inc_url,
                        'qr_url' => 'qrcodes/'.$basename.'.svg',
                        'created_at' => date('Y-m-d H:i:s')
                    );
                    $insertedId = $mysqlClass->insertData('qr_codes', $values);
                }
            }
        } catch (Exception $e) {
            $response = array('error' => 'Exception: ', $e->getMessage());
            echo json_encode($response);
            exit;
        }

        $response = array(
            'basename' => $basename,
            'filedir' => qrcdr()->relativePath().$qrcodes_dir,
        );
        echo json_encode($response);
    } else {
        $response = array('error' => 'Creation failed');
        echo json_encode($response);
    }
}
exit;
