function isValidURL(str) {
  if (/^(http(s):\/\/.)[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)$/g.test(str)) {
    return true;
  } else {
    return false;
  }
}

$(document).ready(function () {
  $("#stepOne_nxt").click(function () {

    var name = $("#agent-basic-details input[name='name']");
    var father_name = $("#agent-basic-details input[name='father_name']");
    var mobile_no = $("#agent-basic-details input[name='mobile_no']");
    var email = $("#agent-basic-details input[name='email']");
    var pan_no = $("#agent-basic-details input[name='pan_no']");
    var dob = $("#agent-basic-details input[name='dob']");
    var alt_no = $("#agent-basic-details input[name='alt_no']");
    var address = $("#agent-basic-details input[name='address']");
    var pincode = $("#agent-basic-details input[name='pin']");
    var state = $("#agent-basic-details input[name='state']");
    var city = $("#agent-basic-details input[name='city']");
    var gst_no = $("#agent-basic-details input[name='gst_no']");
    var annual_income_declaration = $("#agent-basic-details input[name='annual_income_declaration']");
    var msme_declaration = $("#agent-basic-details input[name='msme_declaration']");
    var aadhaar_pan_linked = $("#agent-basic-details input[name='aadhaar_pan_linked']");
    var is_gst_registered = $("#agent-basic-details select[name='is_gst_registered']");
    var is_msme_registered = $("#agent-basic-details select[name='is_msme_registered']");
    var msme_no = $("#agent-basic-details input[name='msme_no']");
    var mobileno = $("#agent-basic-details #mobileno");

    form_valid = true;
    if (name.val() == "") {
      name.addClass("ferror");
      form_valid = false;
    }
    if (father_name.val() == "") {
      father_name.addClass("ferror");
      form_valid = false;
    }
    if (mobile_no.val() == "") {
      mobile_no.addClass("ferror");
      form_valid = false;
    }
    if (email.val() == "") {
      email.addClass("ferror");
      form_valid = false;
    }
    if (pan_no.val() == "") {
      pan_no.addClass("ferror");
      form_valid = false;
    }
    if (dob.val() == "") {
      dob.addClass("ferror");
      form_valid = false;
    }

    if (alt_no.val() != "" && alt_no.val().length != 10) {
      alt_no.addClass("ferror");
      form_valid = false;
    }
    else if (alt_no.val() == mobileno.val()) {
      alt_no.addClass("ferror");
      alt_no.val("");
      $("#alt_err").html("<span class='text-danger inputerr'>Alternate no. can not be same as primary no.</span>");
      form_valid = false;
    }

    if (address.val() == "") {
      address.addClass("ferror");
      form_valid = false;
    }

    if (pincode.val() == "") {
      pincode.addClass("ferror");
      form_valid = false;
    }
    if (city.val() == "") {
      city.addClass("ferror");
      form_valid = false;
    }
    if (state.val() == "") {
      state.addClass("ferror");
      form_valid = false;
    }
    if (is_gst_registered.val() == "") {
      is_gst_registered.addClass("ferror");
      form_valid = false;
    }
    if (is_gst_registered.val() == 1 && gst_no.val() == "") {
      gst_no.addClass("ferror");
      form_valid = false;
    }

    if (is_msme_registered.val() == "") {
      is_msme_registered.addClass("ferror");
      form_valid = false;
    }
    if (is_msme_registered.val() == 1 && msme_no.val() == "") {
      msme_no.addClass("ferror");
      form_valid = false;
    }
    if (is_gst_registered.val() != "1" && annual_income_declaration.is(":checked") == false) {
      $("#annual_income_declaration_err").html("<div class='text-danger'>Please accept the declaration</div>");
      form_valid = false;
    }
    if (is_msme_registered.val() != "1" && msme_declaration.is(":checked") == false) {
      $("#msme_declaration_err").html("<div class='text-danger'>Please accept the declaration</div>");
      form_valid = false;
    }
    if (aadhaar_pan_linked.is(":checked") == false) {
      $("#aadhaar_pan_linked_err").html("<div class='text-danger'>Please choose an option</div>");
      form_valid = false;
    }

    //focus on input
    if (name.val() == "") {
      name.focus();
    }
    else if (father_name.val() == "") {
      father_name.focus();
    }
    else if (mobile_no.val() == "") {
      mobile_no.focus();
    }
    else if (email.val() == "") {
      email.focus();
    }
    else if (pan_no.val() == "") {
      pan_no.focus();
    }
    else if (dob.val() == "") {
      dob.focus();
    }
    else if (alt_no.val() != "" && alt_no.val().length != 10) {
      alt_no.focus();
    }
    else if (alt_no.val() == mobileno.val()) {
      alt_no.focus();
    }
    else if (address.val() == "") {
      address.focus();
    }
    else if (pincode.val() == "") {
      pincode.focus();
    }
    else if (city.val() == "") {
      city.focus();
    }
    else if (state.val() == "") {
      state.focus();
    }
    else if (is_gst_registered.val() == "") {
      is_gst_registered.focus();
    }
    else if (is_gst_registered.val() == 1 && gst_no.val() == "") {
      gst_no.focus();
    }
    else if (is_msme_registered.val() == "") {
      is_msme_registered.focus();
    }

    if (is_gst_registered.val() != "1" && annual_income_declaration.is(":checked") == false) {
      $("#annual_income_declaration_err").html("<div class='text-danger'>Please accept the declaration</div>");
      form_valid = false;
    }
    if (is_msme_registered.val() != "1" && msme_declaration.is(":checked") == false) {
      $("#msme_declaration_err").html("<div class='text-danger'>Please accept the declaration</div>");
      form_valid = false;
    }
    if (aadhaar_pan_linked.is(":checked") == false) {
      $("#aadhaar_pan_linked_err").html("<div class='text-danger'>Please choose an option</div>");
      form_valid = false;
    }

    if (form_valid) {

      $.ajax({
        url: "../ajax/save-agent-basic.php",
        type: "POST",
        data: $("#agent-basic-details").serialize(),
        beforeSend: function () {
          $("#stepOne_nxt").html("<img src='images/green_loader.gif' width='100'>");
        },
        success: function (res) {
          $("#stepOne_nxt").html("Save & Continue");
          var out = JSON.parse(res);
          if (out.status == 1) { 
              let htmlData =`<div class="alert alert-danger alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">
                ×
                </button>${out.hasOwnProperty('MESSAGE') ? out.MESSAGE : out.msg}</div>
                `;
                $(".frmmsg").html(htmlData); 
            // $(".frmmsg").html("<div align='center'><span class='custom-success-msg'>" + out.msg + "</span></div>");
            setTimeout(redirectURL, 3000);
          } else if (out.status == 0) {

            if (out.error_code == 1) {
              $("input[name='pan_no']").addClass("ferror");
              $("input[name='pan_no']").val("");
              $("input[name='pan_no']").focus();
              $("#pan_err").html("<span class='text-danger inputerr'>" + out.msg + "</span>");
            }
            else if (out.error_code == 2) {
              $("input[name='gst_no']").addClass("ferror");
              $("input[name='gst_no']").val("");
              $("input[name='gst_no']").focus();
              $("#gstin_err").html("<span class='text-danger inputerr'>" + out.msg + "</span>");
            }
            else if (out.error_code == 3) {
              $("input[name='msme_no']").addClass("ferror");
              $("input[name='msme_no']").val("");
              $("input[name='msme_no']").focus();
              $("#msme_err").html("<span class='text-danger inputerr'>" + out.msg + "</span>");
            }

          }
        }
      });

      function redirectURL() {
        return reloadWithQueryStringVars({ "step": "bank-info" });
      }
      //$("#step_two").show();
      //$("#step_one").hide();
      // $(".atabs").removeClass("active");
      // $(".tabs-2").addClass("active");
    }

  });


  $("#stepTwo_nxt").click(function () {
    var bank_name = $("#agent-bank-details input[name='bank_name']");
    var bank_ac_no = $("#agent-bank-details input[name='ac_no']");
    var bank_ifsc = $("#agent-bank-details input[name='ifsc_code']");
    var ac_holder_name = $("#agent-bank-details input[name='ac_holder_name']");
    var facebook = $("#agent-bank-details input[name='facebook']");
    var instagram = $("#agent-bank-details input[name='instagram']");
    var linkedin = $("#agent-bank-details input[name='linkedin']");
    var twitter = $("#agent-bank-details input[name='twitter']");
    var telegram = $("#agent-bank-details input[name='telegram']");

    form_valid = true;
    if (bank_name.val() == "") {
      bank_name.addClass("ferror");
      form_valid = false;
    }
    if (bank_ac_no.val() == "") {
      bank_ac_no.addClass("ferror");
      form_valid = false;
    }
    else if (bank_ac_no.val().length < 9 || bank_ac_no.val().length > 18) {
      bank_ac_no.addClass("ferror");
      form_valid = false;
    }
    if (bank_ifsc.val() == "") {
      bank_ifsc.addClass("ferror");
      form_valid = false;
    }
    if (ac_holder_name.val() == "") {
      ac_holder_name.addClass("ferror");
      form_valid = false;
    }
    if (facebook.val() != "" && !isValidURL(facebook.val())) {
      facebook.addClass("ferror");
      form_valid = false;
    }
    if (instagram.val() != "" && !isValidURL(instagram.val())) {
      instagram.addClass("ferror");
      form_valid = false;
    }
    if (linkedin.val() != "" && !isValidURL(linkedin.val())) {
      linkedin.addClass("ferror");
      form_valid = false;
    }
    if (twitter.val() != "" && !isValidURL(twitter.val())) {
      twitter.addClass("ferror");
      form_valid = false;
    }
    if (telegram.val() != "" && !isValidURL(telegram.val())) {
      telegram.addClass("ferror");
      form_valid = false;
    }

    //input focus
    if (bank_name.val() == "") {
      bank_name.focus();
    }
    else if (bank_ac_no.val() == "") {
      bank_ac_no.focus();
    }
    else if (bank_ifsc.val() == "") {
      bank_ifsc.focus();
    }
    else if (ac_holder_name.val() == "") {
      ac_holder_name.focus();
    }
    else if (facebook.val() != "" && !isValidURL(facebook.val())) {
      facebook.focus();
    }
    else if (instagram.val() != "" && !isValidURL(instagram.val())) {
      instagram.focus();
    }
    else if (linkedin.val() != "" && !isValidURL(linkedin.val())) {
      linkedin.focus();
    }
    else if (twitter.val() != "" && !isValidURL(twitter.val())) {
      twitter.focus();
    }
    else if (telegram.val() != "" && !isValidURL(telegram.val())) {
      telegram.focus();
    }

    if (form_valid) {

      $.ajax({
        url: "../ajax/save-agent-bank.php",
        type: "POST",
        data: $("#agent-bank-details").serialize(),
        beforeSend: function () {
          $("#stepTwo_nxt").html("<img src='images/green_loader.gif' width='100'>");
        },
        success: function (res) {
          $("#stepTwo_nxt").html("Save & Continue");
          var out = JSON.parse(res);
          if(out.hasOwnProperty('status') && out.status == '1'){
            let htmlData =`<div class="alert alert-danger alert-dismissable">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">
							×
							</button>${out.hasOwnProperty('MESSAGE') ? out.MESSAGE : out.msg}</div>
							`;
              $(".frmmsg").html(htmlData);
          }else{ 
              let htmlData =`<div class="alert alert-success alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">
                ×
                </button>${out.msg}</div>
                `;
                $(".frmmsg").html(htmlData); 
            // $(".frmmsg").html("<div align='center'><span class='custom-success-msg'>" + out.msg + "</span></div>");
            setTimeout(redirectURL, 3000);
          }
        }
      });

      function redirectURL() {
        return reloadWithQueryStringVars({ "step": "professional-info" });
      }
    }

  });


  $("#stepThree_nxt").click(function () {
    form_valid = true;
    var profession = $("#agent-professional-details select[name='profession']");
    var monthly_income = $("#agent-professional-details select[name='monthly_income']");
    var domain = $("#agent-professional-details select[name='domain']");
    var domain_text = $("#agent-professional-details input[name='domain_text']");
    //var services=$("#agent-professional-details .services");  
    // var service_text=$("#agent-professional-details input[name='service_text']");  
    // var other_service=$("#agent-professional-details .other_service");  
    // form_valid= true;
    // var service_select=false;
    // services.each(function(){
    //   if($(this).is(":checked")){
    //     service_select=true;
    //     $("#service_err").html("");
    //   }
    // })
    if (profession.val() == "") {
      profession.addClass("ferror");
      form_valid = false;
    }
    if (monthly_income.val() == "") {
      monthly_income.addClass("ferror");
      form_valid = false;
    }
    if (domain.val() == "") {
      domain.addClass("ferror");
      form_valid = false;
    }
    if (domain.val() == "Other" && domain_text.val() == "") {
      domain_text.addClass("ferror");
      form_valid = false;
    }
    //focus
    if (profession.val() == "") {
      profession.focus();
    }
    else if (monthly_income.val() == "") {
      monthly_income.focus();
    }
    else if (domain.val() == "") {
      domain.focus();
    }
    else if (domain.val() == "Other" && domain_text.val() == "") {
      domain_text.focus();
    }

    if (form_valid) {
      $.ajax({
        url: "../ajax/save-agent-profession.php",
        type: "POST",
        data: $("#agent-professional-details").serialize(),
        beforeSend: function () {
          $("#stepThree_nxt").html("<img src='images/green_loader.gif' width='100'>");
        },
        success: function (res) {
          $("#stepThree_nxt").html("Save & Continue");
          var out = JSON.parse(res);
          $(".frmmsg").html("<div align='center'><span class='custom-success-msg'>" + out.msg + "</span></div>");
          setTimeout(redirectURL, 3000);
        }
      });

      function redirectURL() {
        return reloadWithQueryStringVars({ "step": "kyc-docs" });
      }
    }
  });


  $("#stepFour_nxt").click(function () {
    form_valid = true;
    var posp_declaration = $("#agent-kyc-docs input[name='posp_declaration']");
    if (posp_declaration.is(":checked") == false) {
      $("#posp_declaration_err").html("<div style='margin-left:10px;margin-top:10px;' class='text-danger'>Please accept the declaration</div>");
      form_valid = false;
    }
    if (form_valid) {
      $("#agent-kyc-docs").submit();
    }
  });


  function reloadWithQueryStringVars(queryStringVars) {
    var existingQueryVars = location.search ? location.search.substring(1).split("&") : [],
      currentUrl = location.search ? location.href.replace(location.search, "") : location.href,
      newQueryVars = {},
      newUrl = currentUrl + "?";
    if (existingQueryVars.length > 0) {
      for (var i = 0; i < existingQueryVars.length; i++) {
        var pair = existingQueryVars[i].split("=");
        newQueryVars[pair[0]] = pair[1];
      }
    }
    if (queryStringVars) {
      for (var queryStringVar in queryStringVars) {
        newQueryVars[queryStringVar] = queryStringVars[queryStringVar];
      }
    }
    if (newQueryVars) {
      for (var newQueryVar in newQueryVars) {
        newUrl += newQueryVar + "=" + newQueryVars[newQueryVar] + "&";
      }
      newUrl = newUrl.substring(0, newUrl.length - 1);
      window.location.href = newUrl;
    } else {
      window.location.href = location.href;
    }
  }

  $(document).on("click", ".other_service", function () {
    if ($(this).is(":checked")) {
      $("#servicetext").show();
    } else {
      $("#servicetext").hide();
    }
  });

  $(document).on("click", ".domain", function () {
    if ($(this).val() == "Other") {
      $(".domaintext").show();
    } else {
      $(".domaintext").hide();
    }
  });

  var pan_regex = /[A-Z]{5}[0-9]{4}[A-Z]{1}$/;
  var gst_regex = /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}$/;
  var ifsc_regex = /^[A-Z]{4}0[A-Z0-9]{6}$/;

  $("input[name='pan_no']").blur(function () {
    var inputvalues = $(this).val();

    if (!pan_regex.test(inputvalues)) {
      $(this).val("");
      $(this).addClass("ferror");
      $("#pan_err").html("<span class='text-danger inputerr'>Please enter valid PAN</span>");
      $("input[name='pan_no']").val("");
      $("input[name='pan_no']").focus();
      return pan_regex.test(inputvalues);
    } else {
      var uid = $("#uid").val();
      $.ajax({
        type: 'POST',
        data: "input=" + inputvalues + "&uid=" + uid + "&field_name=pan_no",
        url: 'ajax/validate-duplicate.php',
        success: function (res) {
          if (res == -1) {
            $("input[name='pan_no']").addClass("ferror");
            $("input[name='pan_no']").val("");
            //$("input[name='pan_no']").focus(); 
            $("#pan_err").html("<span class='text-danger inputerr'>PAN No. already exist.</span>");
          }
        }
      });

      $("#pan_err").html("");
      $(this).removeClass("ferror");
    }
  });
  $("input[name='pan_no']").keyup(function () {
    $(this).val($(this).val().toUpperCase());
    if (pan_regex.test($(this).val())) {
      $("#pan_err").html("");
      $(this).removeClass("ferror");
    }
  });

  $("input[name='gst_no']").blur(function () {
    var inputvalues = $(this).val();
    if (!gst_regex.test(inputvalues)) {
      $(this).val("");
      $(this).addClass("ferror");
      $("#gstin_err").html("<span class='text-danger inputerr'>Please enter valid GSTIN</span>");
      $("input[name='gst_no']").val("");
      //$("input[name='gst_no']").focus(); 
      return gst_regex.test(inputvalues);
    } else {

      var uid = $("#uid").val();
      $.ajax({
        type: 'POST',
        data: "input=" + inputvalues + "&uid=" + uid + "&field_name=gst_no",
        url: 'ajax/validate-duplicate.php',
        success: function (res) {
          if (res == -1) {
            $("input[name='gst_no']").addClass("ferror");
            $("input[name='gst_no']").val("");
            //$("input[name='gst_no']").focus(); 
            $("#gstin_err").html("<span class='inputerr text-danger'>GST No. already exist.</span>");
          }
        }
      });
      $("#gstin_err").html("");
      $(this).removeClass("ferror");
    }
  });
  $("input[name='gst_no']").keyup(function () {
    $(this).val($(this).val().toUpperCase());
    if (gst_regex.test($(this).val())) {
      $("#gstin_err").html("");
      $(this).removeClass("ferror");
    }
  });

  $("input[name='msme_no']").blur(function () {
    var inputvalues = $(this).val();
    if (inputvalues.length != 12) {
      $(this).val("");
      $(this).addClass("ferror");
      $("#msme_err").html("<span class='text-danger inputerr'>Please enter valid msme no.</span>");
      $("input[name='msme_no']").val("");
      //$("input[name='msme_no']").focus();   
      return false;
    } else {
      var uid = $("#uid").val();
      $.ajax({
        type: 'POST',
        data: "input=" + inputvalues + "&uid=" + uid + "&field_name=msme_no",
        url: 'ajax/validate-duplicate.php',
        success: function (res) {
          if (res == -1) {
            $("input[name='msme_no']").addClass("ferror");
            $("input[name='msme_no']").val("");
            $("input[name='msme_no']").focus();
            $("#msme_err").html("<span class='text-danger inputerr'>MSME No. already exist.</span>");
          }
        }
      });
      $("#msme_err").html("");
      $(this).removeClass("ferror");
    }
  });
  $("input[name='msme_no']").keyup(function () {
    var inputvalues = $(this).val();
    if (inputvalues.length == 12) {
      $("#msme_err").html("");
      $(this).removeClass("ferror");
    }
  });

  $("input[name='ifsc_code']").change(function () {
    var inputvalues = $(this).val();
    if (!ifsc_regex.test(inputvalues)) {
      $(this).val("");
      $(this).addClass("ferror");
      $("#ifsc_err").html("<span class='text-danger'>Please enter valid ifsc code</span>");
      $("input[name='ifsc_code']").val("").focus();
      return ifsc_regex.test(inputvalues);
    } else {
      $("#ifsc_err").html("");
      $(this).removeClass("ferror");
    }
  });
  $("input[name='ifsc_code']").keyup(function () {
    $(this).val($(this).val().toUpperCase());
    if (ifsc_regex.test($(this).val())) {
      $("#ifsc_err").html("");
      $(this).removeClass("ferror");
    }
  });

  $("#agent-basic-details select[name='is_gst_registered']").change(function () {
    if ($(this).val() == 1) {
      $(".gst-no-field").show();
      $(".annual_declare").hide();
    } else {
      $(".gst-no-field").hide();
      $(".annual_declare").show();
    }
  });

  $("#agent-basic-details select[name='is_msme_registered']").change(function () {
    if ($(this).val() == 1) {
      $(".msme-no-field").show();
      $(".msme_declare").hide();
    } else {
      $(".msme-no-field").hide();
      $(".msme_declare").show();
    }
  });

  $("#agent-basic-details input[name='annual_income_declaration']").change(function () {
    if ($(this).val() != "") {
      $("#annual_income_declaration_err").html("");
    }
  });

  $("#agent-basic-details input[name='msme_declaration']").change(function () {
    if ($(this).val() != "") {
      $("#msme_declaration_err").html("");
    }
  })
  $("#agent-kyc-docs input[name='posp_declaration']").change(function () {
    if ($(this).val() != "") {
      $("#posp_declaration_err").html("");
    }
  })


  // $("input[name='aadhar_no']").change(function () {      
  //   var inputvalues = $(this).val();        
  //   if(inputvalues.length!=12){     
  //     $(this).val(""); 
  //       swal({
  //         title: "Invalid Aadhaar No.",
  //         text: "Please enter 12 digit aadhaar no.",
  //         icon: "error",
  //         type: "warning"
  //     }).then(function() {
  //         $("input[name='aadhar_no']").val(""); 
  //       $("input[name='aadhar_no']").focus();    
  //     });
  //   return regex.test(inputvalues);    
  //   }    
  // });  
});

// pincode autocomplete start
$(function () {
  var cache = {};
  var isdata = 0;
  $("#pincode-dropdown").autocomplete({
    minLength: 3,
    // open: function() { alert(1); },
    // close: function() { alert(2); },
    // focus: function(event,ui) { alert(3); },
    source: function (request, response) {
      $.ajax({
        dataType: "json",
        type: 'Get',
        data: "term=" + request.term,
        url: 'ajax/get-pincodes.php',
        success: function (data) {
          response(data);
        },
        error: function (data) {
          alert("error");
        }
      });
    },
    select: function (event, ui) {
      $("#pincodeID").val(ui.item.id);
      $("input[name='city']").attr("readonly", true);
      $("input[name='state']").attr("readonly", true);
      $("input[name='city']").val(ui.item.city);
      $("input[name='state']").val(ui.item.state);
      $("input[name='cityID']").val(ui.item.cityID);
      $("input[name='stateID']").val(ui.item.stateID);
      $("input[name='city']").removeClass("ferror");
      $("input[name='state']").removeClass("ferror");
    },
    change: function (event, ui) {
      var input = $(this).val();
      $.ajax({
        dataType: "json",
        type: 'Get',
        data: "term=" + input,
        url: 'ajax/get-pincodes.php',
        success: function (data) {
          if (data == null) {
            $("#pincodeerr").html('<div class="nolookupitem"><a href="javascript:void(0)" class="addPinitem text-info">"' + input + '" does not exist. Click here to Add</a></div>');
            $("#pincodetext").val(input);
            $("#pincode-dropdown").val("");
          } else {
            if ($("#pincodeID").val() == "") {
              $("#pincodeerr").html("<span class='inputerr text-danger'>Please select valid pincode</span>");
              $("#pincode-dropdown").val("");
            }
          }
        }
      });
    }
  });

  $("#pincode-dropdown").blur(function () {
    if ($(this).val() == "") {
      $("input[name='pincode']").val("");
    }
    if ($(this).val() != "" && $("input[name='pincodeID']").val() == "") {
      $(this).val("");
      $("#pincodeerr").html("<span class='inputerr text-danger'>Please select valid pincode</span>");
    }
  });

  $("#pincode-dropdown").keyup(function (e) {
    if (e.which != 13 && e.which != 9) {
      $("#pincodeerr").html("");
      //$("#pincodeID").val("");
      // $("input[name='city']").val("");
      // $("input[name='cityID']").val("");
      // $("input[name='state']").val("");
      // $("input[name='stateID']").val("");
      $("input[name='city']").attr("readonly", false);
      $("input[name='state']").attr("readonly", false);
    }
  });

  // city autocomplete start
  $("#city-autocomplete").autocomplete({
    //open: function() { console.log(1); },
    //close: function() { console.log(2); },
    //focus: function(event,ui) { console.log(3); },
    minLength: 3,
    source: function (request, response) {
      $.ajax({
        dataType: "json",
        type: 'Get',
        data: "term=" + request.term,
        url: 'ajax/get-cities.php',
        success: function (data) {
          //$('input.suggest-user').removeClass('ui-autocomplete-loading');  
          response(data);
        },
        error: function (data) {
          //$('input.suggest-user').removeClass('ui-autocomplete-loading');  
        }
      });
    },
    select: function (event, ui) {
      $("#cityID").val(ui.item.id);
    },
    change: function (event, ui) {
      var input = $(this).val();
      $.ajax({
        dataType: "json",
        type: 'Get',
        data: "term=" + input,
        url: 'ajax/get-cities.php',
        success: function (data) {
          if (data == null) {
            $("#cityerr").html('<div class="nolookupitem"><a href="javascript:void(0)" class="addCityitem text-info">"' + input + '" does not exist. Click here to Add</a></div>');
            $("#citytext").val(input);
            $("#city-autocomplete").val("");
          } else {
            if ($("#cityID").val() == "") {
              $("#cityerr").html("<span class='inputerr text-danger'>Please select valid city</span>");
              $("#city-autocomplete").val("");
            }
          }
        }
      });
    }
  });

  $(document).on("click", ".addCityitem", function () {
    $.ajax({
      url: "ajax/add-city-lookup.php",
      type: "post",
      data: "city=" + $("#citytext").val() + "&pincode=" + $("#pincodetext").val() + "&state=" + $("#stateID").val(),
      success: function (res) {
        var out = JSON.parse(res);
        $("#city-autocomplete").val(out.city);
        $("#cityID").val(out.id);
      }
    })
    $(".nolookupitem").hide();
  });

  $(document).on("click", ".addPinitem", function () {
    $.ajax({
      url: "ajax/add-city-lookup.php",
      type: "post",
      data: "city=" + $("#citytext").val() + "&pincode=" + $("#pincodetext").val() + "&state=" + $("#stateID").val(),
      success: function (res) {
        var out = JSON.parse(res);
        $("#pincode-dropdown").val(out.pincode);
        $("#pincodeID").val(out.id);
      }
    })
    $(".nolookupitem").hide();
  });

  $("#city-autocomplete").keyup(function (e) {
    if (e.which != 13 && e.which != 9) {
      $("#cityerr").html("");
      $("#cityID").val("");
    }
  });

  // state autocomplete start
  $("#state-autocomplete").autocomplete({
    minLength: 3,
    source: function (request, response) {
      $.ajax({
        dataType: "json",
        type: 'Get',
        data: "term=" + request.term,
        url: 'ajax/get-states.php',
        success: function (data) {
          response(data);
        },
        error: function (data) {
        }
      });
    },
    select: function (event, ui) {
      $("#stateID").val(ui.item.id);
      $("#stateerr").html("");
    }
  });

  $("#state-autocomplete").blur(function () {
    if ($(this).val() == "") {
      $("input[name='state']").val("");
    }
    if ($(this).val() != "" && $("input[name='stateID']").val() == "") {
      $(this).val("");
      $("#stateerr").html("<span class='inputerr text-danger'>Please select valid state</span>");
    }
  });

  $("#state-autocomplete").keyup(function (e) {
    if (e.which != 13 && e.which != 9) {
      $("#stateerr").html("<span class='inputerr text-danger'>Please select valid state</span>");
      $("#stateID").val("");
    }
  });
});




function hidekycmsg() {
  $(".custom-success-msg").fadeOut();
}
setTimeout(hidekycmsg, 5000);