<?php
require("../../../config.php");
require("../../../include/lib.php");
require("../../../api/classes/db_class.php");
require("../../../api/classes/comman_class.php");

$helpers = new helper_class();
$mysqlClass = new Mysql_class();
$loanArray = array(
    "5"=>"PERSONAL-LOAN",
    "4"=>"BUSINESS-LOAN" ,
    "2"=>"HOME-LOAN-LAPS" ,
    "2"=>"HOME-LOAN" ,
    "2"=>"HOME-LOAN-SELF-EMP" ,
    "9"=>"EDUCATION-LOAN" ,
    "10"=>"NEW-CAR-LOAN-SALARIED" ,
    "10"=>"USED-CAR-LOAN-SALARIED" ,
    "10"=>"NEW-CAR-LOAN-SELF-EMPLOYED" ,
    "10"=>"USED-CAR-LOAN-SELF-EMPLOYED",
    "0"=>"0"
    );
$oldtable = $mysqlClass->mysqlQuery("SELECT * FROM loan_applications where  is_migrated = '0' limit 20");

$res = $oldtable->fetchAll(PDO::FETCH_ASSOC);

foreach($res as $response){
    if ($response['status'] == ''){
        $status="PENDING";
    }else{
        $status=$response['status'];
    }

    if ($response['income_source'] == 'Salaried'){
        $incomesource="1";
    }else if($response['income_source'] == 'Self Employed'){
        $incomesource="2";
    }else{
        $incomesource="3";
    }

$data=array(
    "id"=>$response['id'],
   "is_migrated" =>1,
    "mobile"=>$response['cMobile'],
    "name"=>$response['cName'],
    "dob"=>$response['dob'],
    "city"=>$response['district'],
    "income_source"=> $incomesource,
    "user_id"=>$response['retailer_id'],
    "application_id"=>$response['application_id'],
    "created_date"=>$response['created_at'],
    "remarks"=>$response['remarks'],
    "status"=> $status,
    "loan_amount"=> $response['loanAmount'],
);

$mysqlClass->insertData('loan_basic_details', $data);



}

foreach($res as $result){
    $values = array(
        "retailer_id"=>$result['retailer_id'],
        "application_id"=>$result['application_id'],
        "first_name"=>$result['cName'],
        "loan_type"=>$loanArray[$result['loanType']],
        "occupation"=>$result['cOccupation'],
        "dependent"=>$result['children'],
        "created_at"=>$result['created_at'],
        "updated_at"=>$result['updated_at'],
    );
    $mysqlClass->insertData('loan_request', $values);
}

foreach($res as $return){
    $rvalues = array(
      
        "application_id"=>$return['application_id'],
        "address_line1"=>$return['cAddress'],
        "pincode"=>$return['pincode'],
        "city"=>$return['district'],
        "state"=>$return['state'],
        "created_at"=>$return['created_at'],
        "updated_at"=>$return['updated_at'],
    );
    $mysqlClass->insertData('loan_addresses', $rvalues);
}

foreach($res as $coreturn){
    $covalues = array(
        "retailer_id"=>$coreturn['retailer_id'],
        "application_id"=>$coreturn['application_id'],
        "created_at"=>$coreturn['created_at'],
        "updated_at"=>$coreturn['updated_at'],
    );
    $mysqlClass->insertData('loan_co_applicant_details', $covalues);
}

foreach($res as $docreturn){
    
    // echo "<pre>"; $count =0;
    // print_r($docreturn);die;
    $docvalues = array(
      
        "application_id"=>$docreturn['application_id'],
        "date_created"=>$docreturn['created_at'],
        "updated_date"=>$docreturn['updated_at'],
    );
    foreach (array_keys($docreturn) as $k => $value ) {
        // print_r($k);
        //  echo "<br>";
        // print_r($value); 
        if($value == 'addressProof'){
            // echo $count;
            $docvalues['doc_type']="address proof";
            $docvalues['file']=$docreturn['addressProof'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'occupationProof'){
            $docvalues['doc_type']="occupation Proof";
            $docvalues['file']=$docreturn['occupationProof'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'uploadedAPFile'){
            $docvalues['doc_type']="uploadedAPFile";
            $docvalues['file']=$docreturn['uploadedAPFile'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'uploadedOpFile'){
            $docvalues['doc_type']="uploadedOpFile";
            $docvalues['file']=$docreturn['uploadedOpFile'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'salary_slip_1'){
            $docvalues['doc_type']="salary_slip_1";
            $docvalues['file']=$docreturn['salary_slip_1'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'salary_slip_2'){
            $docvalues['doc_type']="salary_slip_2";
            $docvalues['file']=$docreturn['salary_slip_2'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'salary_slip_3'){
            $docvalues['doc_type']="salary_slip_3";
            $docvalues['file']=$docreturn['salary_slip_3'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'rent_agreement'){
            $docvalues['doc_type']="rent_agreement";
            $docvalues['file']=$docreturn['rent_agreement'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'business_registration_proof'){
            $docvalues['doc_type']="business_registration_proof";
            $docvalues['file']=$docreturn['business_registration_proof'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'registery_file'){
            $docvalues['doc_type']="registery_file";
            $docvalues['file']=$docreturn['registery_file'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'itr_file'){
            $docvalues['doc_type']="itr_file";
            $docvalues['file']=$docreturn['itr_file'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'business_proof'){
            $docvalues['doc_type']="business_proof";
            $docvalues['file']=$docreturn['business_proof'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'bank_statement_file'){
            $docvalues['doc_type']="bank_statement_file";
            $docvalues['file']=$docreturn['bank_statement_file'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        else if($value == 'pan_file'){
            $docvalues['doc_type']="pan_file";
            $docvalues['file']=$docreturn['pan_file'];
            $mysqlClass->insertData('loan_docs', $docvalues);
        }
        // print_r($docvalues);
        // $mysqlClass->insertData('loan_docs', $docvalues);
        }
        // die;
      
}
foreach($res as $refreturn){
    $refvalues = array(
        "retailer_id"=>$refreturn['retailer_id'],
        "application_id"=>$refreturn['application_id'],
        "created_at"=>$refreturn['created_at'],
        "updated_at"=>$refreturn['updated_at'],
    );
    $mysqlClass->insertData('loan_reference_details', $refvalues);
}

foreach($res as $addreturn){

    $addvalues = array(
        "retailer_id"=>$addreturn['retailer_id'],
        "application_id"=>$addreturn['application_id'],
        "created_at"=>$addreturn['created_at'],
        "updated_at"=>$addreturn['updated_at'],
    );
    $mysqlClass->insertData('loan_address_details', $addvalues);

    $loan_pk_id = $addreturn['id'];
    $SQLU = "update loan_applications SET is_migrated = 1 where id = '$loan_pk_id' ";
    echo $SQLU."=======================<br/>";
    $mysqlClass->mysqlQuery($SQLU);
}
