<?php
/*************** 
ERROR_CODE -> 0 - Success / 1 - Error
MESSAGE -> ""
***************/
	require("../../config.php");
	require("../classes/db_class.php");
	require("../classes/comman_class.php");
	require("../classes/user_class.php");
	require("../classes/jwt_encode_decode.php");
	 
	$helpers = new Helper_class();
	$mysqlClass = new Mysql_class();
	$userClass = new User_class();
	$jwtED = new jwt_encode_decode();
	
	if($_SERVER['HTTP_X_API_KEY']==HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY']==DGFNAPASSKEY){	
	} else {
		$helpers->errorResponse("Authorization Invalid !");
	}
	
	if($_SERVER['REQUEST_METHOD']=="POST" && isset($_POST)){
		
		$post = $helpers->clearSlashes($_POST);	
	
		//// Valided Token and Get Token Details ////
		if(isset($post['token'])){
			$res = $jwtED->decode_token($post['token']);
			if(isset($res->USER_ID) && $res->USER_ID > 0){
				$USER_ID 	= $res->USER_ID;
				$CREATOR_ID	= $res->CREATOR_ID;
				$WL_ID 		= $res->WL_ID;
				$ADMIN_ID 	= $res->ADMIN_ID;
			} else {
				$helpers->errorResponse("Token Expire");
			}
		} else {
			$helpers->errorResponse("Token not set!");
		}
		/////////////////// End //////////////////
		
		
		$bankDetail = $mysqlClass->fetchRow("retailer_bank_details", " id ", " where user_id ='".$USER_ID."'  ORDER BY  id DESC LIMIT 1");
		
		if(isset($bankDetail['id']) && $bankDetail['id'] >0 )
		{
			//return bank details
			$bankData = $mysqlClass->fetchRow("retailer_bank_details", " bank_name,account_number,account_name,branch,ifsc ", " where user_id ='".$USER_ID."' ORDER BY  id DESC LIMIT 1");
			
			$response['ERROR_CODE'] = 0;
			$response['MESSAGE'] = 'Bank details found.';
			$response['DATA']	= $bankData;
		}
		else{
			
			if(isset($post['bank_name']) || isset($post['account_number']) || isset($post['account_name']) || isset($post['ifsc']) || isset($post['branch']))
			{
				//validate $post data....
				if(!isset($post['bank_name']) || $post['bank_name'] ==""){
					$helpers->errorResponse("Invalid Bank Name");
				}
				if(!isset($post['account_number']) || $post['account_number'] == ""){
					$helpers->errorResponse("Invalid Account Number");
				}
				if(!isset($post['account_name']) || $post['account_name'] == "" ){
					$helpers->errorResponse("Invalid Account Name");
				}
				if(!isset($post['ifsc']) || $post['ifsc'] == "" ){
					$helpers->errorResponse("Invalid IFSC Code");
				}
				if(!isset($post['branch']) || $post['branch'] == "" ){
					$helpers->errorResponse("Invalid Branch Name");
				}
				
				//insert bank details
				$data = array(
					'bank_name'				=> $post['bank_name'],
					'account_number'		=> $post['account_number'],					
					'account_name'			=> $post['account_name'],
					'ifsc'					=> $post['ifsc'],
					'branch'				=> $post['branch'],
					'user_id'				=> $USER_ID,					
					'admin_id'				=> $ADMIN_ID,	
					'date_created'			=> date("Y-m-d H:i:s"),
				);
				$id = $mysqlClass->insertData('retailer_bank_details',$data);
				
				$bankData = $mysqlClass->fetchRow("retailer_bank_details", " bank_name,account_number,account_name,branch,ifsc ", " where user_id ='".$USER_ID."' ORDER BY  id DESC LIMIT 1");
				$response['ERROR_CODE'] = 0;
				$response['MESSAGE'] = 'Bank details Saved.';
				$response['DATA']	= $bankData;
			}
			else{
				//no any bank detail
				$response['ERROR_CODE'] = 1;
				$response['MESSAGE'] = 'Bank details not set.';
			}
		}
	}
	else {
		$helpers->errorResponse("Invalid request !");
	}
	echo json_encode($response);
	
	$mysqlClass->close_connection();
	die();	
		
?>