<?php
/************* Only for Loan and Insurance Retailer Registration (Netpaisa.in B2C) ***************/
require "../config.php";
require "classes/db_class.php";
require "classes/comman_class.php";
require "classes/user_class.php";
require "classes/common/Common.php";
require "classes/jwt_encode_decode.php";

$helpers = new Helper_class();
$commonfunction = new Common();
$mysqlClass = new Mysql_class();
$userClass = new User_class();
$jwtED = new jwt_encode_decode();

function requiredInput($inputArr, $requiredFields)
{
    foreach ($requiredFields as $v) {
        if (!isset($inputArr[$v]) || empty($inputArr[$v])) {
            $emptyError[] = $v;
        }
    }
    return $emptyError;
}

if ($_SERVER['HTTP_X_API_KEY'] == HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY'] == DGFNAPASSKEY) {
} else {
    $helpers->errorResponse("Authorization Invalid !");
}

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {

    $post = $helpers->clearSlashes($_POST);
    //echo json_encode($post); die();
    $requiredFields = array('name', 'email', 'mobile', 'address', 'state', 'city', 'pin', 'cname', 'pan_no', 'aadhar_no', 'domain', 'usertype', 'otp');
    $errorRequired = requiredInput($post, $requiredFields);
    if (!empty($errorRequired)) {
        foreach ($errorRequired as $eE) {
            $helpers->errorResponse("Please enter valid " . $eE);
        }
    }

    /* Check Reistration is Already exist with requested mobile and payment status.*/
    /* Code changed by Abhishek Tomar (refer code).*/

    $sqlUserAlreadyReg = $mysqlClass->fetchRow("add_cust", " id,wl_id ", " WHERE mobile = '" . $post['mobile'] . "' and wl_id=WL_IDCONTANT ");
    if (isset($sqlUserAlreadyReg['id']) && $sqlUserAlreadyReg['id'] > 0) {

        /*Check Payment status*/
        $sqlPaymentStatus = $mysqlClass->fetchRow("online_fund_request_details", " id,status ", " WHERE user_id = '" . $sqlUserAlreadyReg['id'] . "' ");
        if (isset($sqlPaymentStatus['id']) && $sqlUserAlreadyReg['id'] > 0) {
            $payment_status = ($sqlPaymentStatus['status'] == 0) ? "Pending" : "Success";
        } else {
            $payment_status = "Pending";
        }

        $response['ERROR_CODE'] = 0;
        $response['MESSAGE'] = "Registration Successfully done. ";
        $response['DATA']['user_id'] = $sqlUserAlreadyReg['id'];
        $response['DATA']['wl_id'] = $sqlUserAlreadyReg['wl_id'];
        $response['DATA']['payment_status'] = $payment_status;

    } else {

        /************* check special character start ***************/

        $checkname['name'] = $post['name'];

        $check_special_name = $commonfunction->check_special_details($checkname, $num = '');
        if (isset($check_special_name['msg']) && !empty($check_special_name['msg'])) {
            $helpers->errorResponse($check_special_name['msg']);
        }

        $checkarr['cname'] = $post['cname'];
        // $checkarr['address'] = $post['address'];
        $domain = $post['domain'];
        $usertype = $post['usertype'];
        $name = $post['name'];
        $otp = $post['otp'];

        /*
        $check_special_details = $commonfunction->check_special_details($checkarr,$num = true);

        if(isset($check_special_details['msg']) && !empty($check_special_details['msg']))
        {
        $helpers->errorResponse($check_special_details['msg']);
        }
         */

        if (!preg_match('/^[0-9]{10}+$/', $post['mobile'])) {
            $helpers->errorResponse('Please enter valid mobile.');
        }

        if (!filter_var($post['email'], FILTER_VALIDATE_EMAIL)) {
            $helpers->errorResponse('Please enter valid email.');
        }
        if (!preg_match("/^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/", $post['pan_no'])) {
            $helpers->errorResponse('Please enter valid pan_no.');
        }
        if (!preg_match('/^[0-9]{12}+$/', $post['aadhar_no'])) {
            $helpers->errorResponse('Please enter valid aadhar_no.');
        }
        if (!in_array($usertype, ['RETAILER', 'DISTRIBUTOR'])) {
            $helpers->errorResponse('Please enter valid usertype.');
        }

        $current_time = date('Y-m-d H:i:s', time());
        $previous_time = date('Y-m-d H:i:s', strtotime("-10 min"));

        $getWlId = $mysqlClass->fetchRow("add_white_label", " user_id ", " WHERE domain = '" . $domain . "' ");

        $checkOtp = $mysqlClass->fetchRow("customer_otps", " otp ", " WHERE mobile_number = '" . $post['mobile'] . "' and otp = '" . $otp . "' and is_expired = '0' and created_at between '" . $previous_time . "' and '" . $current_time . "' and user_id = 0 ");

        if (isset($checkOtp['otp']) && $checkOtp['otp'] == $otp) {
            $dValuesOt = array(
                'is_expired' => 1,
                'updated_at' => $current_time,
            );
            $mysqlClass->updateData(' customer_otps ', $dValuesOt, " WHERE mobile_number = '" . $post['mobile'] . "' and otp = '" . $otp . "' and is_expired = '0' and created_at between '" . $previous_time . "' and '" . $current_time . "' and user_id = 0 ");
        } else {
            //echo " WHERE mobile_number = '".$post['mobile']."' and otp = '".$otp."' and is_expired = '0' and created_at between '".$previous_time."' and '".$current_time."' and user_id = 0 ";
            //$helpers->errorResponse('Please enter valid otp.');
        }
        //print_r($getWlId);
        if (!isset($getWlId['user_id']) || $getWlId['user_id'] != 28823) {
            $helpers->errorResponse('Wrong Source Origin.');
        }

        $getAdminId = $mysqlClass->fetchRow("add_cust", " admin_id ", " WHERE id = '" . $getWlId['user_id'] . "' ");
        //// Check Admin api_access_key ////
        $ADMIN_ID = isset($getAdminId['admin_id']) ? $getAdminId['admin_id'] : '';
        $apiAccessKey = $userClass->get_api_access_key($ADMIN_ID);

        if (empty($apiAccessKey['api_access_key'])) {
            $helpers->errorResponse('Admin API Access Key Not Set.');
        }
        $api_access_key = $apiAccessKey['api_access_key'];

        /////////////////// End //////////////////

        $DIST_ID = 46705;
        $WL_ID = 28823;

        $countUser = $mysqlClass->countRows("select id from `add_cust` WHERE wl_id='" . $WL_ID . "' and (`email`='" . $post['email'] . "' OR `mobile`='" . $post['mobile'] . "' ) ");
        if ($countUser > 0) {
            $helpers->errorResponse('User already exist with email or mobile');
        }

        /********************* Upload KYC Document Start ********************************************************************************************************/

        if (isset($_FILES['aadhar_file']['name']) && !empty($_FILES['aadhar_file']['name'])) {
            $newName1 = 'AD_' . $post['aadhar_no'] . '_' . $USER_ID;
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('aadhar_file', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $helpers->errorResponse($res['error']);
            } else {
                $aadharFileUpload = $helpers->fileUpload($_FILES["aadhar_file"], "../uploads/kyc-doc/", $newName1, true);
                if ($aadharFileUpload['type'] == "success") {
                    $aadhar_file_name = $aadharFileUpload['filename'];
                } else {
                    $aadharFileUploadError = isset($aadharFileUpload['message']) ? $aadharFileUpload['message'] : 'Aadhar Upload error!';
                    $helpers->errorResponse($aadharFileUploadError);
                }
            }
        } else {
            $helpers->errorResponse('Aadhaar Image is required!');
        }

        if (isset($_FILES['pan_file']['name']) && !empty($_FILES['pan_file']['name'])) {
            $newName2 = 'PN_' . $post['pan_no'] . '_' . $USER_ID;
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('pan_file', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $helpers->errorResponse($res['error']);
            } else {
                $panFileUpload = $helpers->fileUpload($_FILES["pan_file"], "../uploads/kyc-doc/", $newName2, true);
                if ($panFileUpload['type'] == "success") {
                    $pan_file_name = $panFileUpload['filename'];
                } else {
                    $panFileUploadError = isset($panFileUpload['message']) ? $panFileUpload['message'] : 'Pan Upload error!';
                    $helpers->errorResponse($panFileUploadError);
                }
            }
        } else {
            $helpers->errorResponse('PAN Image is required!');
        }

        if (isset($_FILES['shop_img']['name']) && !empty($_FILES['shop_img']['name'])) {
            $newName3 = 'SI' . $post['shop_img'] . '_' . $USER_ID;
            $filesize_limit = "2000000";
            $allowedExtensions = array('jpg', 'png', 'pdf', 'jpeg');
            $res = sanitizeAndValidateFile('shop_img', $allowedExtensions, $filesize_limit);
            if (isset($res['error'])) {
                $helpers->errorResponse($res['error']);
            } else {
                $shopFileUpload = $helpers->fileUpload($_FILES["shop_img"], "../uploads/kyc-doc/", $newName3, true);
                if ($shopFileUpload['type'] == "success") {
                    $shopFileUpload = $shopFileUpload['filename'];
                } else {
                    $shopFileUploadError = isset($shopFileUpload['message']) ? $shopFileUpload['message'] : 'Shop image Upload error!';
                    $helpers->errorResponse($shopFileUploadError);
                }
            }
        } else {
            $helpers->errorResponse('Shop Image is required!');
        }

        /********************* Upload KYC Document End ***********************************************************************************************************/

        $pass = bin2hex(random_bytes(5)); // generate random password
        $s_pin = mt_rand(1000, 10000); // generate random login pin
        $hash_pass = $helpers->hashPassword($pass);
        $spin = $helpers->hashPin($s_pin);

        $distPackage = $mysqlClass->fetchRow("add_cust", " package_id ", " WHERE id = '" . $DIST_ID . "' and usertype = 'DISTRIBUTOR' ");
        if ($usertype == 'RETAILER') {
            $packageID = isset($distPackage['package_id']) ? $distPackage['package_id'] : 0;

            $service_access = isset($post['service_access']) ? implode(",", $post['service_access']) : '';
            $value = array(
                'name' => $name,
                'mobile' => $post['mobile'],
                'pass' => $hash_pass['encrypted'],
                'security_pin' => $spin['encrypted'],
                'master_pin' => $spin['encrypted'],
                'email' => $post['email'],
                'cname' => $post['cname'],
                'state_code' => $post['state'],
                'state' => $post['state'],
                'district_code' => $post['city'],
                'city' => $post['city'],
                'pin' => $post['pin'],
                'aadhar_no' => $post['aadhar_no'],
                'pan_no' => $post['pan_no'],
                'shop_categary' => $post['shop_category'],
                'referred_by' => $post['referred_by'],
                'gst_no' => '',
                'service_access' => 'loan,insurance',
                'address' => $post['address'],
                'package_id' => $packageID,
                'status' => 'ENABLED',
                'api_access_key' => $api_access_key,
                'usertype' => "RETAILER",
                'created_on' => date("Y-m-d H:i:s"),
                'created_by' => 'DISTRIBUTOR',
                'irctc_remark' => 'b2c',
                'creator_id' => $DIST_ID,
                'wl_id' => $WL_ID,
                'admin_id' => $ADMIN_ID,
                'aadhar_file' => $aadhar_file_name,
                'pan_file' => $pan_file_name,
                'gst_file' => '',
                'otp_on_email' => 0,
                'otp_on_sms' => 0,
            );

            $last_id = $mysqlClass->insertData('add_cust', $value);
            // $last_idd = $mysqlClass->insertData('add_cust_20220303',$value);
            if ($last_id > 0) {
                $uId = 'RT' . $last_id;

                $dValues = array(
                    'user' => $uId,
                );
                //           $dValuesid = array(
                //     'id'=> $last_id,
                //             );
                $mysqlClass->updateData(' add_cust ', $dValues, " where id = '" . $last_id . "' ");
                //  $mysqlClass->updateData('add_cust_20220303', $dValues, " where id = '".$last_idd."' ");
                // $mysqlClass->updateData('add_cust_20220303', $dValuesid, " where id = '".$last_idd."' ");
                $dValue = array(
                    'user_id' => $last_id,
                    'status' => 'Active',
                    'created_by' => 'DISTRIBUTOR',
                    'creator_id' => $DIST_ID,
                    'package_id' => $packageID,
                );

                $mysqlClass->insertData(' add_retailer ', $dValue);

                /******* Create Login Id End ******************/

                /*********************** customer details start ***************/

                $valid_on = date('Y-m-d H:i:s', strtotime('+ 60 days'));
                $cValue = array(

                    'user_id' => $last_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'shop_category' => $post['shop_category'],
                    'specify_category' => '',
                    'expected_volume' => $post['expected_volume'],
                    'landmark' => '',
                    'c_landmark' => '',
                    'c_district' => $post['city'],
                    'c_state_code' => $post['state'],
                    'c_pin' => $post['pin'],
                    'shop_owner' => '',
                    'dob' => '',
                    'address' => $post['address'],
                    'shop_img' => $shopFileUpload,
                    'aadhar_mask' => '',
                    'referral_mobile_no' => $post['ref_mobile_no'],
                    'valid_on' => $valid_on,

                );
                $mysqlClass->insertData(' cust_details ', $cValue);

                /*********************** customer details end ***************/

                /* Update User Child limit */

                /*$wlDetail = $mysqlClass->mysqlQuery(" select sms_api from add_cust where id = '".$WL_ID."' ");
                $resWL = $wlDetail->fetch(PDO::FETCH_ASSOC);

                $wl_domain = $mysqlClass->fetchRow("add_white_label"," domain ", " WHERE user_id = '".$WL_ID."' ");
                $wlDomain = !empty($wl_domain['domain']) ? $wl_domain['domain'] : '';

                $userDetailes = "LoginId: ".$uId." Password: ".$pass." PIN: ".$s_pin." Website: ".$wlDomain;

                if($resWL['sms_api']=='CUSTOM'){
                $sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='".$WL_ID."' and `admin_id`='".$ADMIN_ID."'" )->fetch(PDO::FETCH_ASSOC);
                } else {
                $sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='".$ADMIN_ID."'" )->fetch(PDO::FETCH_ASSOC);

                if(empty($sms_pack['id'])){
                $sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='1'" )->fetch(PDO::FETCH_ASSOC);
                }
                }

                $smsParameters = json_decode($sms_pack['api_parameters'],true);
                $smsParameters[$sms_pack['param_mobile_name']] = $post['mobile'];
                $smsParameters[$sms_pack['param_msg_name']] = $userDetailes;
                $smsParameters['request_type'] = $sms_pack['request_type'];
                $smsParameters['url'] = $sms_pack['url'];
                $sms_api_res =  $helpers->send_msg_dynamic($smsParameters); */

                $response['ERROR_CODE'] = 0;
                $response['MESSAGE'] = "Registration Successfully done. ";
                /*Added on 15-01-2022 for Razorpay process by Intzar Saifi*/
                $response['DATA']['user_id'] = $last_id;
                $response['DATA']['wl_id'] = $WL_ID;
                $response['DATA']['payment_status'] = "Pending";

            } else {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = 'Registration failed , Please try again';
            }
        } else if ($usertype == 'DISTRIBUTOR') {
            $service_access = isset($post['service_access']) ? implode(",", $post['service_access']) : '';
            $value = array(
                'name' => $name,
                'mobile' => $post['mobile'],
                'pass' => $hash_pass['encrypted'],
                'security_pin' => $spin['encrypted'],
                'master_pin' => $spin['encrypted'],
                'email' => $post['email'],
                'cname' => $post['cname'],
                'state_code' => $post['state'],
                'state' => $post['state'],
                'district_code' => $post['city'],
                'city' => $post['city'],
                'pin' => $post['pin'],
                'aadhar_no' => $post['aadhar_no'],
                'pan_no' => $post['pan_no'],
                'gst_no' => '',
                'service_access' => 'loan,insurance',
                'address' => $post['address'],
                'package_id' => 0,
                'status' => 'ENABLED',
                'api_access_key' => $api_access_key,
                'usertype' => "DISTRIBUTOR",
                'created_on' => date("Y-m-d H:i:s"),
                'created_by' => 'WL',
                'creator_id' => $WL_ID,
                'wl_id' => $WL_ID,
                'admin_id' => $ADMIN_ID,
                'aadhar_file' => $aadhar_file_name,
                'pan_file' => $pan_file_name,
                'gst_file' => '',
            );

            $last_id = $mysqlClass->insertData('add_cust', $value);

            if ($last_id > 0) {
                $uId = 'DT' . $last_id;

                $dValues = array(
                    'user' => $uId,
                );

                $mysqlClass->updateData(' add_cust ', $dValues, " where id = '" . $last_id . "' ");
                $dValue = array(
                    'user_id' => $last_id,
                    'status' => 'Active',
                    'created_by' => 'WL',
                    'creator_id' => $WL_ID,
                    'is_master_distributor' => 0,
                    'package_id' => 0,
                );

                $mysqlClass->insertData(' add_distributer ', $dValue);

                /******* Create Login Id End ******************/

                /*********************** customer details start ***************/

                $valid_on = date('Y-m-d H:i:s', strtotime('+ 60 days'));
                $cValue = array(

                    'user_id' => $last_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'shop_category' => $post['shop_category'],
                    'specify_category' => '',
                    'expected_volume' => $post['expected_volume'],
                    'landmark' => '',
                    'c_landmark' => '',
                    'c_district' => $post['city'],
                    'c_state_code' => $post['state'],
                    'c_pin' => $post['pin'],
                    'shop_owner' => '',
                    'dob' => '',
                    'address' => $post['address'],
                    'shop_img' => $shopFileUpload,
                    'aadhar_mask' => '',
                    'referral_mobile_no' => $post['ref_mobile_no'],
                    'valid_on' => $valid_on,

                );
                $mysqlClass->insertData(' cust_details ', $cValue);

                /*********************** customer details end ***************/

                /* Update User Child limit */

                /*$wlDetail = $mysqlClass->mysqlQuery(" select sms_api from add_cust where id = '".$WL_ID."' ");
                $resWL = $wlDetail->fetch(PDO::FETCH_ASSOC);

                $wl_domain = $mysqlClass->fetchRow("add_white_label"," domain ", " WHERE user_id = '".$WL_ID."' ");
                $wlDomain = !empty($wl_domain['domain']) ? $wl_domain['domain'] : '';

                $userDetailes = "LoginId: ".$uId." Password: ".$pass." PIN: ".$s_pin." Website: ".$wlDomain;

                if($resWL['sms_api']=='CUSTOM'){
                $sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='".$WL_ID."' and `admin_id`='".$ADMIN_ID."'" )->fetch(PDO::FETCH_ASSOC);
                } else {
                $sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='".$ADMIN_ID."'" )->fetch(PDO::FETCH_ASSOC);

                if(empty($sms_pack['id'])){
                $sms_pack = $mysqlClass->mysqlQuery("select * from `sms_pack` WHERE `user_id`='0' and `api_for`='ADMIN' and `admin_id`='1'" )->fetch(PDO::FETCH_ASSOC);
                }
                }

                $smsParameters = json_decode($sms_pack['api_parameters'],true);
                $smsParameters[$sms_pack['param_mobile_name']] = $post['mobile'];
                $smsParameters[$sms_pack['param_msg_name']] = $userDetailes;
                $smsParameters['request_type'] = $sms_pack['request_type'];
                $smsParameters['url'] = $sms_pack['url'];
                $sms_api_res =  $helpers->send_msg_dynamic($smsParameters); */

                $response['ERROR_CODE'] = 0;
                $response['MESSAGE'] = "Registration Successfully done. ";
                /*Added on 15-01-2022 for Razorpay process by Intzar Saifi*/
                $response['DATA']['user_id'] = $last_id;
                $response['DATA']['wl_id'] = $WL_ID;
                $response['DATA']['payment_status'] = "Pending";
            } else {
                $response['ERROR_CODE'] = 1;
                $response['MESSAGE'] = 'Registration failed , Please try again';
            }
        }
    }

} else {
    $response['ERROR_CODE'] = 1;
    $response['MESSAGE'] = 'Invalid request !';
}
echo json_encode($response);

$mysqlClass->close_connection();
die();
