<?php

/*************** 
ERROR_CODE -> 0 - Success / 1 - Error
MESSAGE -> ""
 ***************/
require("../../config.php");
require("../classes/db_class.php");
require("../classes/comman_class.php");
require("../classes/user_class.php");
require("../classes/jwt_encode_decode.php");

$helpers = new Helper_class();
$mysqlClass = new Mysql_class();
$userClass = new user_class();
$jwtED = new jwt_encode_decode();


if ($_SERVER['HTTP_X_API_KEY'] == HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY'] == DGFNAPASSKEY) {
} else {
    $helpers->errorResponse("Authorization Invalid !");
}

$post = $helpers->clearSlashes($_POST);

if (isset($post) && !empty($post)) {
    if (isset($post['token'])) {
        $res = $jwtED->decode_token($post['token']);
        if (isset($res->USER_ID) && $res->USER_ID > 0) {
            $USER_ID     = $res->USER_ID;
            $CREATOR_ID    = $res->CREATOR_ID;
            $WL_ID         = $res->WL_ID;
            $ADMIN_ID     = $res->ADMIN_ID;
        } else {
            $helpers->errorResponse("Token Expire");
        }
    } else {
        $helpers->errorResponse("Token not set!");
    }

    if(empty($post['cName'])){
        $helpers->errorResponse("Name is required.");
    }

   if(empty($post['cMobile'])){
        $helpers->errorResponse("Mobile number is required.");
    }elseif(!preg_match('/^[0-9]{10}+$/', $post['cMobile'])){
            $helpers->errorResponse("Please enter valid 10 digits and space is not allowed.");  
        }

   if(empty($post['loanType'])){
        $helpers->errorResponse("Loan type is required.");
    }

   if(empty($post['loanAmount'])){
        $helpers->errorResponse("Loan amount is required.");
    }elseif(!is_numeric($post['loanAmount'])){
        $helpers->errorResponse("Loan amount should be numeric."); 
    } 

    elseif(($post['loanType==1'] && ['loanAmount<50000'] )){
        $helpers->errorResponse("Loan amount should be more than Rs. 50000/-."); 
    }
    
    
      $data = array(
                    "retailer_id"=> $USER_ID,
                    "cName"=>$post['cName'],
                    "cEmail"=>$post['cEmail'],
                    "cMobile"=>$post['cMobile'],
                    "loanType"=>$post['loanType'],
                    "loanAmount"=>$post['loanAmount'],
                    "created_at"=>date("Y-m-d G:i:s")
                );  
    $id =  $mysqlClass->insertData('loan_applications',$data);
    $prefix = "LA";
    $application_id =  sprintf("%s%05s", $prefix, $id);
   
    $uData = array("application_id"=>$application_id);
    $query = "UPDATE loan_applications SET application_id ='".$application_id."' WHERE id='".$id."'";
    $mysqlClass->mysqlQuery($query);

    $response['ERROR_CODE'] = 0;
    $response['APPLICATION_ID'] = $application_id;
    $response['MESSAGE'] = "Request submited sucessfully.";  
       
    // } else {
    //     $helpers->errorResponse("Problem in file upload.");
    // }
    echo json_encode($response);
}
// }

