<?php

/*************** 

ERROR_CODE -> 0 - Success / 1 - Error

MESSAGE -> ""

***************/
require("../../config.php");
require("../classes/db_class.php");
require("../classes/comman_class.php");
require("../classes/user_class.php");
require("../classes/jwt_encode_decode.php");
require("../classes/CommonFunction.php");
   
$helpers = new Helper_class();
$mysqlClass = new Mysql_class();
$jwtED = new jwt_encode_decode();
$cfo  = new CommonFunction();

if($_SERVER['HTTP_X_API_KEY']==HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY']==DGFNAPASSKEY){	
} else {

	$helpers->errorResponse("Authorization Invalid !");
}

	if($_SERVER['REQUEST_METHOD']=="POST" && isset($_POST)){
		$post = $helpers->clearSlashes($_POST);
// 		//// Valided Token and Get Token Details ////

		if(isset($post['token'])){
			$res = $jwtED->decode_token($post['token']);
			if(isset($res->USER_ID) && $res->USER_ID > 0){
				$USER_ID 	= $res->USER_ID;
				$CREATOR_ID	= $res->CREATOR_ID;
				$WL_ID 		= $res->WL_ID;
				$ADMIN_ID 	= $res->ADMIN_ID;
				$USER_TYPE  = $res->USER_TYPE;
			}else {
				$helpers->errorResponse("Token Expire");
			}

		} else {
				$helpers->errorResponse("Token not set!");
		}

		$applicationId = $_POST['applicationId'];

		if($applicationId == ''){
			$helpers->errorResponse("Please enter application id!");
		}

		/////////////////// End //////////////////

		//// Check Parameters Isset ////
		
$sql = "SELECT la.*, ac.name, ac.user FROM `loan_applications` AS `la` INNER JOIN add_cust AS `ac` ON(ac.id=la.retailer_id) WHERE la.application_id = '".$applicationId."' "; 
$c = $mysqlClass->mysqlQuery($sql)->fetch(PDO::FETCH_ASSOC);

if(!empty($c)){

   $records = array_map(function($value) {
   return is_null($value) ? "" : $value;
}, $c); 
  if($records['loanType']==2){
    $loanType = "Home Loan";
  }elseif($records['loanType']==3){
    $loanType = "Loan Against Property";
  }else{
    $loanType  = "Gold Loan";
  }

$records['loanType'] = $loanType;
$records['loanSubType'] = !is_null($records['loanSubType']) ? $cfo->getSubloanTypeBYId($records['loanSubType']): "NA";
$records['addressProof'] = !is_null($records['addressProof']) ? BASE_URL.'uploads/loan/'.$records['addressProof']: "NA";
$records['occupationProof'] = !is_null($records['occupationProof']) ? BASE_URL.'uploads/loan/'.$records['occupationProof']: "NA";

$response['ERROR_CODE'] = 0;
$response['MESSAGE'] = 'Report Found';
$response['DATA'] = $records;

}else{
$helpers->errorResponse("Wrong application id !");	
}
}else {
$helpers->errorResponse("Invalid request !");
}
echo json_encode($response);
$mysqlClass->close_connection();
die();
?>