<?php
require("../config.php");
require("classes/db_class.php");
require("classes/comman_class.php");
require("classes/user_class.php");
require("classes/common/Common.php");
require("classes/jwt_encode_decode.php");

$helpers = new Helper_class();
$commonfunction = new Common();
$mysqlClass = new Mysql_class();
$userClass = new User_class();
$jwtED = new jwt_encode_decode();


function requiredInput($inputArr, $requiredFields)
{
	foreach ($requiredFields as $v) {
		if (!isset($inputArr[$v]) || empty($inputArr[$v])) {
			$emptyError[] = $v;
		}
	}
	return $emptyError;
}

if ($_SERVER['HTTP_X_API_KEY'] == HTTP_X_API_KEY && $_SERVER['HTTP_DGFNAPASSKEY'] == DGFNAPASSKEY) {
} else {
	$helpers->errorResponse("Authorization Invalid !");
}

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST)) {
	$post = $helpers->clearSlashes($_POST);

	//// Valided Token and Get Token Details ////
	if (isset($post['token'])) {
		$res = $jwtED->decode_token($post['token']);
		if (isset($res->USER_ID) && $res->USER_ID > 0) {
			$USER_ID 	= $res->USER_ID;
			$CREATOR_ID	= $res->CREATOR_ID;
			$WL_ID 		= $res->WL_ID;
			$ADMIN_ID 	= $res->ADMIN_ID;
		} else {
			$helpers->errorResponse("Token Expire");
		}
	} else {
		$helpers->errorResponse("Token not set!");
	}
	/////////////////// End //////////////////


	$requiredFields = array('interest');
	$errorRequired = requiredInput($post, $requiredFields);
	if (!empty($errorRequired)) {
		foreach ($errorRequired as $eE) {
			$helpers->errorResponse("Please enter valid " . $eE);
		}
	}
	$user = $mysqlClass->fetchRow("add_cust", " name,user,admin_id,wl_id,mobile ", " WHERE id = '" . $USER_ID . "' ");
	$dValue = array(
		'user'     => $USER_ID,
		'interest'      => $post['interest'],
		'name'        => $user['name'],
		'wl_id'      => $post['wl_id'],
		'date_created'  => date("Y-m-d H:i:s"),
		'request'  => 1,
		'mobile'  => $user['mobile'],
		'status'  => 'PENDING',
	);

	$mysqlClass->insertData('matm_intrested', $dValue);



	$response['ERROR_CODE'] = 0;
	$response['MESSAGE'] = "Thanks For Your Interest";
} else {
	$response['ERROR_CODE'] = 1;
	$response['MESSAGE'] = 'Invalid request !';
}
echo json_encode($response);
$mysqlClass->close_connection();
die();
